/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.loot;

import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockShulkerBox;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryEmpty;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.conditions.LootConditionManager;
import net.minecraft.world.storage.loot.conditions.RandomChance;
import net.minecraft.world.storage.loot.functions.EnchantWithLevels;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.LootFunctionManager;
import net.minecraft.world.storage.loot.functions.SetCount;
import net.minecraft.world.storage.loot.functions.SetDamage;
import net.minecraft.world.storage.loot.functions.SetMetadata;
import net.minecraft.world.storage.loot.functions.SetNBT;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.RandomStringUtils;
import org.jwaresoftware.mcmods.lib.ItemStackArray;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.api.ILootedListener;
import org.jwaresoftware.mcmods.lib.loot.KilledByRealPlayerCondition;
import org.jwaresoftware.mcmods.lib.loot.RandomChanceWithLuckCondition;
import org.jwaresoftware.mcmods.lib.loot.SetUnbreakableFunction;

public final class Loot {
    public static final String MINECRAFT_POOLNAME = "main";
    public static final String DEFAULT_EXTENSION_POOLNAME = "hord_xlootpool";
    static final Map<String, ConcurrentMap<ResourceLocation, Map<String, List<LootEntry>>>> lootDefsINSTANCE = new ConcurrentHashMap<String, ConcurrentMap<ResourceLocation, Map<String, List<LootEntry>>>>();
    public static final LootCondition[] _NOC = new LootCondition[0];
    private static final LootFunction[] _NOF = new LootFunction[0];
    static final Map<ResourceLocation, LootTable> xlootTablesINSTANCE = new ConcurrentHashMap<ResourceLocation, LootTable>();
    private static boolean _DEFAULTS_INITED = false;

    public static final boolean isEnabled(String modid) {
        return modid != null && lootDefsINSTANCE.containsKey(modid);
    }

    public static final void clearAll(String modid) {
        if (modid != null) {
            lootDefsINSTANCE.remove(modid);
        } else {
            lootDefsINSTANCE.clear();
        }
    }

    static final ConcurrentMap<ResourceLocation, Map<String, List<LootEntry>>> getModDefs(@Nonnull String modid) {
        ConcurrentMap<ResourceLocation, Map<String, List<LootEntry>>> modDefs = lootDefsINSTANCE.get(modid);
        if (modDefs == null) {
            modDefs = new ConcurrentHashMap<ResourceLocation, Map<String, List<LootEntry>>>();
            lootDefsINSTANCE.put(modid, modDefs);
        }
        return modDefs;
    }

    public static final LootEntryItem createEntryItem(String oid, Item item, int weight, int quality) {
        return new LootEntryItem(item, weight, quality < 0 ? 0 : quality, _NOF, _NOC, oid);
    }

    public static final LootEntryItem createEntryItem(String oid, Item item, int count, int weight, int quality) {
        return new LootEntryItem(item, weight, quality < 0 ? 0 : quality, new LootFunction[]{new SetCount(_NOC, new RandomValueRange((float)count))}, _NOC, oid);
    }

    public static final LootEntryItem createEntryItem(String oid, Item item, int min, int max, int weight, int quality) {
        return new LootEntryItem(item, weight, quality < 0 ? 0 : quality, new LootFunction[]{new SetCount(_NOC, new RandomValueRange((float)min, (float)max))}, _NOC, oid);
    }

    public static final LootEntryItem createEntryFlatItem(String oid, ItemStack item, int weight, int quality, float chance) {
        int nFunc;
        boolean nbt = item.func_77942_o() && !item.func_77978_p().func_82582_d();
        int count = item.func_190916_E();
        int n = nFunc = count > 1 ? 1 : 0;
        if (nbt) {
            ++nFunc;
        }
        LootFunction[] functions = new LootFunction[nFunc];
        int i = 0;
        if (count > 1) {
            functions[i++] = new SetCount(_NOC, new RandomValueRange((float)count));
        }
        if (nbt) {
            NBTTagCompound body = item.func_77978_p().func_74737_b();
            functions[i++] = new SetNBT(_NOC, body);
        }
        LootCondition[] conditions = _NOC;
        if (chance > 0.0f) {
            conditions = new LootCondition[]{new RandomChance(chance)};
        }
        return new LootEntryItem(item.func_77973_b(), weight, quality < 0 ? 0 : quality, functions, conditions, oid);
    }

    public static final LootEntryItem createEntryItem(String oid, ItemStack item, int weight, int quality, float chance) {
        boolean nbt = item.func_77942_o() && !item.func_77978_p().func_82582_d();
        int nFunc = item.func_77981_g() ? 1 : 0;
        int count = item.func_190916_E();
        if (count > 1) {
            ++nFunc;
        }
        if (nbt) {
            ++nFunc;
        }
        LootFunction[] functions = new LootFunction[nFunc];
        int i = 0;
        if (item.func_77981_g()) {
            functions[i++] = new SetMetadata(_NOC, new RandomValueRange((float)item.func_77960_j()));
        }
        if (count > 1) {
            functions[i++] = new SetCount(_NOC, new RandomValueRange((float)count));
        }
        if (nbt) {
            NBTTagCompound body = item.func_77978_p().func_74737_b();
            functions[i++] = new SetNBT(_NOC, body);
        }
        LootCondition[] conditions = _NOC;
        if (chance > 0.0f) {
            conditions = new LootCondition[]{new RandomChance(chance)};
        }
        return new LootEntryItem(item.func_77973_b(), weight, quality < 0 ? 0 : quality, functions, conditions, oid);
    }

    public static final LootEntryItem createEntryItem(String oid, ItemStack item, int weight) {
        return Loot.createEntryItem(oid, item, weight, -1, 0.0f);
    }

    public static final LootEntryItem createEntryItem(String oid, ItemStack item, int min, int max, int weight, int quality, float chance) {
        int nFunc;
        boolean nbt = item.func_77942_o() && !item.func_77978_p().func_82582_d();
        int n = nFunc = item.func_77981_g() ? 2 : 1;
        if (nbt) {
            ++nFunc;
        }
        LootFunction[] functions = new LootFunction[nFunc];
        int i = 0;
        if (item.func_77981_g()) {
            functions[i++] = new SetMetadata(_NOC, new RandomValueRange((float)item.func_77960_j()));
        }
        functions[i++] = new SetCount(_NOC, new RandomValueRange((float)min, (float)max));
        if (nbt) {
            NBTTagCompound body = item.func_77978_p().func_74737_b();
            functions[i++] = new SetNBT(_NOC, body);
        }
        LootCondition[] conditions = _NOC;
        if (chance > 0.0f) {
            conditions = new LootCondition[]{new RandomChance(chance)};
        }
        return new LootEntryItem(item.func_77973_b(), weight, quality < 0 ? 0 : quality, functions, conditions, oid);
    }

    public static final LootEntryItem createEntryItem(String oid, ItemStack item, int min, int max, int weight) {
        return Loot.createEntryItem(oid, item, min, max, weight, -1, 0.0f);
    }

    public static final LootEntryItem createEntryItem(String oid, Item item, int weight, int quality, LootFunction ... functions) {
        return new LootEntryItem(item, weight, quality, functions, _NOC, oid);
    }

    public static final LootEntryItem createEntryItem(String oid, Item item, int weight, int quality, LootCondition[] conditions, LootFunction ... functions) {
        return new LootEntryItem(item, weight, quality, functions, conditions, oid);
    }

    public static final LootEntryItem createDamagedItem(String oid, Item item, float min_damage, float max_damage, int weight, int quality) {
        return new LootEntryItem(item, weight, quality < 0 ? 0 : quality, new LootFunction[]{new SetDamage(_NOC, new RandomValueRange(min_damage, max_damage))}, _NOC, oid);
    }

    public static final LootEntryItem createDamagedItem(String oid, Item item, float min_damage, float max_damage, int min_elvl, int max_elvl, int weight, int quality) {
        return new LootEntryItem(item, weight, quality < 0 ? 0 : quality, new LootFunction[]{new SetDamage(_NOC, new RandomValueRange(min_damage, max_damage)), new EnchantWithLevels(_NOC, new RandomValueRange((float)min_elvl, (float)max_elvl), min_elvl > 19)}, _NOC, oid);
    }

    public static final void addLootEntry(String modid, ResourceLocation tableid, String poolid, LootEntry e) {
        ArrayList<LootEntry> loot;
        ConcurrentMap<ResourceLocation, Map<String, List<LootEntry>>> modDefs = Loot.getModDefs(modid);
        HashMap<String, ArrayList<LootEntry>> poolDefs = (HashMap<String, ArrayList<LootEntry>>)modDefs.get(tableid);
        if (poolDefs == null) {
            poolDefs = new HashMap<String, ArrayList<LootEntry>>();
            modDefs.put(tableid, poolDefs);
        }
        if (poolid == null || poolid.isEmpty()) {
            poolid = MINECRAFT_POOLNAME;
        }
        if ((loot = (ArrayList<LootEntry>)poolDefs.get(poolid)) == null) {
            loot = new ArrayList<LootEntry>();
            poolDefs.put(poolid, loot);
        }
        loot.add(e);
    }

    public static final void addFiller(String modid, ResourceLocation tableid, String poolid, int weight) {
        LootEntryEmpty e = new LootEntryEmpty(weight, 0, _NOC, "empty_" + modid + "_" + RandomStringUtils.randomAlphanumeric((int)6));
        Loot.addLootEntry(modid, tableid, poolid, (LootEntry)e);
    }

    public static final void addFiller(String modid, ResourceLocation tableid, String poolid, int weight, int n) {
        LootEntryEmpty e = new LootEntryEmpty(weight, 0, _NOC, "empty_" + modid + "_" + n);
        Loot.addLootEntry(modid, tableid, poolid, (LootEntry)e);
    }

    public static final void addFishedUpJunk(String modid, String oid, Item item) {
        Loot.addLootEntry(modid, LootTableList.field_186388_am, null, (LootEntry)Loot.createEntryItem(oid, item, SharedGlue.JUNK_WEIGHT(), -1));
    }

    public static final void addFishedUpJunk(String modid, String oid, ItemStack item) {
        Loot.addLootEntry(modid, LootTableList.field_186388_am, null, (LootEntry)Loot.createEntryItem(oid, item, SharedGlue.JUNK_WEIGHT()));
    }

    public static final void addFishedUpJunk(String modid, String oid, Item item, float min_damage, float max_damage) {
        Loot.addLootEntry(modid, LootTableList.field_186388_am, null, (LootEntry)Loot.createDamagedItem(oid, item, min_damage, max_damage, SharedGlue.JUNK_WEIGHT() - 2, -1));
    }

    public static final void addFishedUpJunk(String modid, String oid, Item item, float min_damage, float max_damage, int min_elvl, int max_elvl) {
        Loot.addLootEntry(modid, LootTableList.field_186388_am, null, (LootEntry)Loot.createDamagedItem(oid, item, min_damage, max_damage, min_elvl, max_elvl, SharedGlue.JUNK_WEIGHT() - 2, -1));
    }

    public static final void addFishedUpUncommon(String modid, String oid, Item item) {
        Loot.addLootEntry(modid, LootTableList.field_186388_am, null, (LootEntry)Loot.createEntryItem(oid, item, SharedGlue.UNCOMMON_WEIGHT(), -1));
    }

    public static final void addFishedUpUncommon(String modid, String oid, ItemStack item) {
        Loot.addLootEntry(modid, LootTableList.field_186388_am, null, (LootEntry)Loot.createEntryItem(oid, item, SharedGlue.UNCOMMON_WEIGHT()));
    }

    public static final void addFishedUpTreasure(String modid, String oid, Item item) {
        Loot.addLootEntry(modid, LootTableList.field_186389_an, null, (LootEntry)Loot.createEntryItem(oid, item, SharedGlue.TREASURE_WEIGHT(), -1));
    }

    public static final void addFishedUpTreasure(String modid, String oid, ItemStack item) {
        Loot.addLootEntry(modid, LootTableList.field_186389_an, null, (LootEntry)Loot.createEntryItem(oid, item, SharedGlue.TREASURE_WEIGHT()));
    }

    public static final void merge(String modid, LootTableLoadEvent event) {
        ConcurrentMap<ResourceLocation, Map<String, List<LootEntry>>> modDefs;
        Map poolDefs;
        if (Loot.isEnabled(modid) && (poolDefs = (Map)(modDefs = Loot.getModDefs(modid)).get(event.getName())) != null) {
            for (String poolid : poolDefs.keySet()) {
                LootPool pool = event.getTable().getPool(poolid);
                if (pool != null) {
                    for (LootEntry e : (List)poolDefs.get(poolid)) {
                        pool.addEntry(e);
                    }
                    continue;
                }
                if (Loot.isExtensionPool(poolid) && !Loot.isMainExtensionPool(poolid)) {
                    pool = new LootPool(new LootEntry[0], _NOC, new RandomValueRange(1.0f), new RandomValueRange(0.0f, 0.0f), poolid);
                    event.getTable().addPool(pool);
                    for (LootEntry e : (List)poolDefs.get(poolid)) {
                        pool.addEntry(e);
                    }
                }
                if (pool != null) continue;
                System.err.println(modid + " unable to find pool id='" + poolid + "' for loot load for " + event.getName());
            }
        }
    }

    public static final boolean isMainExtensionPool(String poolid) {
        return DEFAULT_EXTENSION_POOLNAME.equals(poolid);
    }

    public static final boolean isExtensionPool(String poolid) {
        return poolid != null && poolid.startsWith(DEFAULT_EXTENSION_POOLNAME);
    }

    public static final String asExtensionPool(String suffix) {
        return "hord_xlootpool_" + suffix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static final LootTable getModdedLootTable(@Nonnull ResourceLocation tableLoc, @Nonnull World world) {
        if (tableLoc.func_110623_a().startsWith("*RANDOM")) {
            return LootTable.field_186464_a;
        }
        if ("minecraft".equals(tableLoc.func_110624_b())) {
            LootTable loottable_minecraft = world.func_184146_ak().func_186521_a(tableLoc);
            return loottable_minecraft != null ? loottable_minecraft : LootTable.field_186464_a;
        }
        Map<ResourceLocation, LootTable> map = xlootTablesINSTANCE;
        synchronized (map) {
            LootTable loottable = xlootTablesINSTANCE.get(tableLoc);
            if (loottable == null) {
                loottable = world.func_184146_ak().func_186521_a(tableLoc);
                if (!loottable.isFrozen()) {
                    LootTable loottable_modded = ForgeEventFactory.loadLootTable((ResourceLocation)tableLoc, (LootTable)loottable, (LootTableManager)world.func_184146_ak());
                    if (loottable_modded == null) {
                        loottable_modded = LootTable.field_186464_a;
                    }
                    if (loottable_modded != LootTable.field_186464_a && !loottable_modded.isFrozen()) {
                        loottable_modded.freeze();
                    }
                    loottable = loottable_modded;
                }
                xlootTablesINSTANCE.put(tableLoc, loottable);
            }
            return loottable;
        }
    }

    @Nonnull
    public static final List<Integer> getEmptySlotsRandomized(IItemHandler inventory, Random rand) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int n = inventory.getSlots();
        for (int i = 0; i < n; ++i) {
            if (!inventory.getStackInSlot(i).func_190926_b()) continue;
            list.add(i);
        }
        Collections.shuffle(list, rand);
        return list;
    }

    @Nullable
    public static final ResourceLocation getTopLevelLootTable(@Nonnull ItemStack from) {
        if (from.func_77942_o()) {
            NBTTagCompound itemdata = from.func_77978_p();
            String rstring = null;
            if (itemdata.func_150297_b(SharedGlue.DEFAULT_LOOT_TABLE_TAGNAME(), 8)) {
                rstring = itemdata.func_74779_i(SharedGlue.DEFAULT_LOOT_TABLE_TAGNAME());
            } else if (itemdata.func_150297_b("withLoot", 8)) {
                rstring = itemdata.func_74779_i("withLoot");
            }
            if (rstring != null && !rstring.isEmpty()) {
                return new ResourceLocation(rstring);
            }
        }
        return null;
    }

    public static final ItemStack[] newStackArray(int slotCount) {
        return ItemStackArray.create(slotCount);
    }

    public static final List<Integer> getEmptySlots(IInventory inventory, Random rand) {
        ArrayList<Integer> empty_slots = new ArrayList<Integer>();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            if (!ItemStacks.isEmpty(inventory.func_70301_a(i))) continue;
            empty_slots.add(i);
        }
        if (rand != null) {
            Collections.shuffle(empty_slots, rand);
        }
        return empty_slots;
    }

    public static final ItemStack createShulkerbox(EnumDyeColor color) {
        return BlockShulkerBox.func_190953_b((EnumDyeColor)(color == null ? EnumDyeColor.WHITE : color));
    }

    public static final ItemStack createUndyedShulkerbox() {
        return BlockShulkerBox.func_190953_b((EnumDyeColor)EnumDyeColor.PURPLE);
    }

    protected Loot() {
    }

    public static final void init0() {
    }

    public static final void initDefaults() {
        if (_DEFAULTS_INITED) {
            return;
        }
        LootConditionManager.func_186639_a((LootCondition.Serializer)new RandomChanceWithLuckCondition.Serializer());
        LootConditionManager.func_186639_a((LootCondition.Serializer)new KilledByRealPlayerCondition.Serializer());
        LootFunctionManager.func_186582_a((LootFunction.Serializer)new SetUnbreakableFunction.Serializer(true));
        _DEFAULTS_INITED = true;
    }

    public static abstract class OnLootedFunction
    extends LootFunction {
        protected OnLootedFunction(LootCondition[] conditions) {
            super(conditions);
        }

        public ItemStack func_186553_a(ItemStack stack, Random rand, LootContext context) {
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof ILootedListener) {
                Entity e = context.func_186495_b();
                Object player = e instanceof EntityPlayer ? (EntityPlayer)e : FakePlayerFactory.getMinecraft((WorldServer)context.getWorld());
                try {
                    ((ILootedListener)stack.func_77973_b()).notifyLooted(stack, (World)context.getWorld(), (EntityPlayer)player, context.func_186491_f());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return stack;
        }

        public static abstract class Serializer<K extends LootFunction>
        extends LootFunction.Serializer<K> {
            protected Serializer(String mod_id, Class<K> funcClass) {
                super(new ResourceLocation(mod_id, "on_looted"), funcClass);
            }

            public void func_186532_a(JsonObject object, K lfunction, JsonSerializationContext serializationContext) {
            }
        }
    }

    public static abstract class OnCreatedFunction
    extends LootFunction {
        protected OnCreatedFunction(LootCondition[] conditions) {
            super(conditions);
        }

        public ItemStack func_186553_a(ItemStack stack, Random rand, LootContext context) {
            if (!stack.func_190926_b()) {
                Entity e = context.func_186495_b();
                Object player = e instanceof EntityPlayer ? (EntityPlayer)e : FakePlayerFactory.getMinecraft((WorldServer)context.getWorld());
                try {
                    stack.func_77973_b().func_77622_d(stack, (World)context.getWorld(), player);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return stack;
        }

        public static abstract class Serializer<K extends LootFunction>
        extends LootFunction.Serializer<K> {
            protected Serializer(String mod_id, Class<K> funcClass) {
                super(new ResourceLocation(mod_id, "on_created"), funcClass);
            }

            public void func_186532_a(JsonObject object, K lfunction, JsonSerializationContext serializationContext) {
            }
        }
    }
}

